    <?php
	/*
	* copyright (c) 2013-2020 Heliac Technologies
	* license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
	*
	* linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
	*/
        $arrayColori = array(""=>"Trasparente","bg-primary"=>"Primary","bg-secondary"=>"Secondary","bg-success"=>"Success","bg-info"=>"Info","bg-warning"=>"Warning","bg-danger"=>"Danger","bg-light"=>"Light","bg-dark"=>"Dark","bg-white"=>"Bianco");
        $coloreMenu = array("navbar-dark"=>"Chiaro","navbar-light"=>"Scuro");
    ?>

    <h4 class="mb-4 title">Aspetto</h4>
    
    <div class="row mt-5">
        <div class="col-12">
            <h5>Configurazione aspetto</h5>
            <hr>
        </div>
                
        <div class="col-lg-6">
            <label>Carica una configurazione</label>
            <div class="input-group">
                <select class="form-control" id="idConfigurazione">
                    <?php 
                        $queryPagine = "SELECT * FROM geec_configurazioniAspetto";
                        $risConfigurazioni = $geecomDb->eseguiQueryLettura($queryPagine);
                        while($configurazione = $risConfigurazioni->fetch_assoc()) {
                            if($configurazione["selezionataAdmin"]=="si") {
                                echo"<option value=\"{$configurazione["id"]}\" selected >{$configurazione["nome"]}</option>";
                            }
                            else {
                                echo"<option value=\"{$configurazione["id"]}\">{$configurazione["nome"]}</option>";
                            }
                        }
                    ?>
                </select>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="caricaConfigurazione()" >Carica</button>
                </div>
            </div>
            <small class="text-muted"><?php echo $configurazioneColore["descrizione"]; ?></small>
        </div>
        <div class="col-lg-6">
            <label>Operazioni</label><br>
            <button class="btn btn-outline-primary" type="button" data-toggle="modal" data-target="#modalClonaConfigurazione"><i class="fas fa-clone"></i> Clona</button>
            <button class="btn btn-outline-primary" type="button" onclick="esportaConfigurazione()"><i class="fas fa-file-export"></i> Esporta</button>
        </div>
    </div>
    
    <div class="row mt-5">
        <div class="col-12">
            <h5>Logo</h5>
            <hr>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <img class="img-fluid bg-light p-3 mb-3" id="immagineLogo" src="../<?php echo($configurazioneColore["logo"]); ?>" >
            </div>
        </div>

        <div class="col-lg-6">
            <form action="../controller/controllerImpostazioni.php" id="frmLogo" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                <div class="dz-message">
                    <i class="fas fa-file-upload fa-2x mb-2"></i>
                    <h5>Trascina o carica qui l'immagine</h5>
                </div>
                <div class="fallback">
                    <input name="file" type="file" />
                </div>
            </form>
        </div>
    </div>
    
    <div class="row mt-5">
        <div class="col-12">
            <h5>Favicon</h5>
            <hr>
        </div>

        <div class="col-lg-6">
            <div class="form-group">
                <img class="img-fluid bg-light p-3 mb-3" id="immagineFavicon" src="../<?php echo($configurazioneColore["favicon"]); ?>" alt="favicon">
            </div>
        </div>

        <div class="col-lg-6">
            <form action="../controller/controllerImpostazioni.php" id="frmFavicon" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                <div class="dz-message">
                    <i class="fas fa-file-upload fa-2x mb-2"></i>
                    <h5>Trascina o carica qui l'immagine</h5>
                </div>
                <div class="fallback">
                    <input name="file" type="file" />
                </div>
            </form>
        </div>
    </div>

    <div class="row mt-5">
        <div class="col-12">
            <h5>File di stile</h5>
            <hr>
        </div>

        <div class="col-lg-6">
            <div class="form-group mb-2">
                <h6>stile.css</h6>
                <form action="../controller/controllerImpostazioni.php" id="frmStileCss" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                    <div class="dz-message">
                        <i class="fas fa-file-upload fa-2x mb-2"></i>
                        <h5>Trascina o carica qui stile.css</h5>
                    </div>
                    <div class="fallback">
                        <input name="file" type="file" />
                    </div>
                </form>
            </div>
            <small class="text-muted">Qui puoi caricare il file stile.css personalizzato. <strong>Attenzione, il vecchio file verrà sovrascritto!</strong></small><br>
            <small><?php echo "Ultima versione caricata il ".date("d/m/Y H:i:s.", filemtime("../template/stile.css")); ?></small>
            <hr>
            <a href="../controller/controllerImpostazioni.php?operazione=scaricaFileStileCss" class="btn btn-outline-primary float-right"><i class="fas fa-download"></i> Scarica versione attuale</a>
        </div>

        <div class="col-lg-6">
            <div class="form-group mb-2">
                <h6>stile.php</h6>
                <form action="../controller/controllerImpostazioni.php" id="frmStilePhp" class="dropzone singolo-file" method="post" enctype="multipart/form-data">
                    <div class="dz-message">
                        <i class="fas fa-file-upload fa-2x mb-2"></i>
                        <h5>Trascina o carica qui stile.php</h5>
                    </div>
                    <div class="fallback">
                        <input name="file" type="file" />
                    </div>
                </form>
            </div>
            <small class="text-muted">Qui puoi caricare il file stile.php personalizzato. <strong>Attenzione, il vecchio file verrà sovrascritto!</strong></small><br>
            <small><?php echo "Ultima versione caricata il ".date("d/m/Y H:i:s.", filemtime("../template/stile.php")); ?></small>
            <hr>
            <a href="../controller/controllerImpostazioni.php?operazione=scaricaFileStilePhp" class="btn btn-outline-primary float-right"><i class="fas fa-download"></i> Scarica versione attuale</a>
        </div>

    </div>
    
    <form action="../controller/controllerImpostazioni.php" method="post" >
        <input class="d-none" type="text" name="id" value="<?php echo $configurazioneColore["id"]; ?>" />
        <input class="d-none" type="text" name="operazione" value="aggiornaColoriConfigurazione" />
        <div class="row mt-5">
                <div class="col-12">
                    <h5>Colori </h5>
                    <hr>
                </div>
        
                <div class="col-md-4 col-xl-3">
                        <label>Primary </label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimario" name="colorePrimario" value="<?php echo $configurazioneColore["colorePrimario"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                        <label>Primary hover</label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimarioHover" name="colorePrimarioHover" value="<?php echo $configurazioneColore["colorePrimarioHover"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>										

                        <label>Primary active</label>
                        <div class="input-group colorpicker-component selettore-colore mb-3">
                            <input type="text" id="colorePrimarioActive" name="colorePrimarioActive" value="<?php echo $configurazioneColore["colorePrimarioActive"]; ?>" class="form-control" />
                            <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                        </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Secondary</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                          <input type="text" id="coloreSecondario" name="coloreSecondario" value="<?php echo $configurazioneColore["coloreSecondario"]; ?>" class="form-control" />
                          <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Secondary hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                          <input type="text" id="coloreSecondarioHover" name="coloreSecondarioHover" value="<?php echo $configurazioneColore["coloreSecondarioHover"]; ?>" class="form-control" />
                          <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Secondary active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                          <input type="text"  id="coloreSecondarioActive" name="coloreSecondarioActive" value="<?php echo $configurazioneColore["coloreSecondarioActive"]; ?>" class="form-control" />
                          <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Light </label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreLight" name="coloreLight" value="<?php echo $configurazioneColore["coloreLight"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Light hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreLightHover" name="coloreLightHover" value="<?php echo $configurazioneColore["coloreLightHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>										

                    <label>Light active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreLightActive" name="coloreLightActive" value="<?php echo $configurazioneColore["coloreLightActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Dark </label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDark" name="coloreDark" value="<?php echo $configurazioneColore["coloreDark"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Dark hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDarkHover" name="coloreDarkHover" value="<?php echo $configurazioneColore["coloreDarkHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>										

                    <label>Dark active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDarkActive" name="coloreDarkActive" value="<?php echo $configurazioneColore["coloreDarkActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Success</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreSuccess" name="coloreSuccess" value="<?php echo $configurazioneColore["coloreSuccess"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Success hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreSuccessHover" name="coloreSuccessHover" value="<?php echo $configurazioneColore["coloreSuccessHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Success active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreSuccessActive" name="coloreSuccessActive" value="<?php echo $configurazioneColore["coloreSuccessActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Info </label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreInfo" name="coloreInfo" value="<?php echo $configurazioneColore["coloreInfo"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Info hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreInfoHover" name="coloreInfoHover" value="<?php echo $configurazioneColore["coloreInfoHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Info active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreInfoActive" name="coloreInfoActive" value="<?php echo $configurazioneColore["coloreInfoActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Warning </label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreWarning" name="coloreWarning" value="<?php echo $configurazioneColore["coloreWarning"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Warning hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreWarningHover" name="coloreWarningHover" value="<?php echo $configurazioneColore["coloreWarningHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Warning active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreWarningActive" name="coloreWarningActive" value="<?php echo $configurazioneColore["coloreWarningActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-md-4 col-xl-3">
                    <label>Danger </label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDanger" name="coloreDanger" value="<?php echo $configurazioneColore["coloreDanger"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                    <label>Danger hover</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDangerHover" name="coloreDangerHover" value="<?php echo $configurazioneColore["coloreDangerHover"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>										

                    <label>Danger active</label>
                    <div class="input-group colorpicker-component selettore-colore mb-3">
                        <input type="text" id="coloreDangerActive" name="coloreDangerActive" value="<?php echo $configurazioneColore["coloreDangerActive"]; ?>" class="form-control" />
                        <span class="input-group-append"><span class="input-group-addon input-group-text"><i></i></span></span>
                    </div>
                </div>
                <div class="col-12 mt-3">
                    <button type="submit" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
                </div>
        </div>
    </form>

    <form action="../controller/controllerImpostazioni.php" method="post" >
        <input class="d-none" type="text" name="id" value="<?php echo $configurazioneColore["id"]; ?>" />
        <input class="d-none" type="text" name="operazione" value="aggiornaBreakingPointConfigurazione" />
        <div class="row mt-5">
            <div class="col-12">
                <h5>Breaking points </h5>
                <hr>
            </div>

            <div class="col-md-3">
                <div class="form-group">
                    <label for="breakpoint-sm">breakpoint-sm </label>
                    <input type="text" class="form-control" id="breakpoint-sm" name="breakingPointSm" placeholder="576px" value="<?php echo $configurazioneColore["breakingPointsXs"]; ?>">
                </div>
            </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="breakpoint-md">breakpoint-md </label>
                    <input type="text" class="form-control" id="breakpoint-md" name="breakingPointMd" placeholder="768px" value="<?php echo $configurazioneColore["breakingPointsMd"]; ?>">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="breakpoint-lg">breakpoint-lg </label>
                    <input type="text" class="form-control" id="breakpoint-lg" name="breakingPointLg" placeholder="992px" value="<?php echo $configurazioneColore["breakingPointsLg"]; ?>">
                  </div>
                </div>
                <div class="col-md-3">
                  <div class="form-group">
                    <label for="breakpoint-xl">breakpoint-xl </label>
                    <input type="text" class="form-control" id="breakpoint-xl" name="breakingPointXl" name="breakpoint-xl" placeholder="1200px" value="<?php echo $configurazioneColore["breakingPointsXl"]; ?>">
                  </div>
                </div>

                <div class="col-12 mt-3">
                        <button class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
                </div><!--/usa questo markup se ti serve un salvataggio di una singola sezione-->

        </div>
    </form>

    <form action="../controller/controllerImpostazioni.php" method="post" >
        <input class="d-none" type="text" name="id" value="<?php echo $configurazioneColore["id"]; ?>" />
        <input class="d-none" type="text" name="operazione" value="cambiaFontConfigurazioneAspetto" />
        <div class="row mt-5">
            <div class="col-12">
                <h5>Font</h5>
                <hr>
            </div>

            <div class="col-12">
                <div class="form-group">
                    <label for="font-intestazioni">Link font </label>
                    <input type="text" class="form-control" name="linkFont" id="font-intestazioni" value="<?php echo $configurazioneColore["linkFont"]; ?>" placeholder="Es: https://fonts.googleapis.com/css?family=Source+Serif+Pro">
                    <small class="text-muted">Es: https://fonts.googleapis.com/css2?family=Open+Sans&family=Pattaya&display=swap<br>Geecom usa i Google Fonts, per un elenco completo visita <a href="https://fonts.google.com/" target="_blank" class="bg-transparent"> https://fonts.google.com </a></small>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="form-group">
                    <label for="font-intestazioni">Intestazioni </label>
                    <textarea rows="2" name="fontIntestazioni" class="form-control" id="fontIntestazioni"><?php echo $configurazioneColore["fontIntestazioni"]; ?></textarea>
                    <small class="text-muted">Es: font-family:'Pattaya', sans-serif;</small>
                </div>
            </div>

            <div class="col-xl-6">
                <div class="form-group">
                    <label for="font-corpo-testo">Testi </label>
                    <textarea rows="2" name="fontTesti" class="form-control" id="fontTesti"><?php echo $configurazioneColore["fontTesti"]; ?></textarea>
                    <small class="text-muted">Es: font-family:'Open Sans', sans-serif;</small>
                </div>
            </div>

            <div class="col-12 mt-3">
                <button type="submit" class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
            </div><!--/usa questo markup se ti serve un salvataggio di una singola sezione-->
        </div>
    </form>
         
    <form action="../controller/controllerImpostazioni.php" method="post" >
        <input class="d-none" type="text" name="id" value="<?php echo $configurazioneColore["id"]; ?>" />
        <input class="d-none" type="text" name="operazione" value="aggiornaImpostazioniBarraMenu" />
        
        <div class="row mt-5">
            <div class="col-12">
                <h5>Barra menu principale</h5>
                <hr>
            </div>

            <div class="col-lg-6">
                <label>Colore sfondo</label>
                <select class="form-control" id="sfondoBarraMenu" name="sfondoBarraMenu">
                <?php 
                    foreach($arrayColori as $classe=>$colore) {
                        if($configurazioneColore["sfondoBarraMenu"]==$classe) {
                            echo"<option value=\"$classe\" selected>$colore</option>";
                        }
                        else {
                            echo"<option value=\"$classe\">$colore</option>";
                        }
                    }
                ?>
                </select>
            </div>

            <div class="col-lg-6">
                <label>Colore testi</label>
                <select class="form-control" id="coloreTestoBarraMenu" name="coloreTestoBarraMenu">
                <?php 
                    foreach($coloreMenu as $classe=>$colore) {
                        if($configurazioneColore["coloreTestoBarraMenu"]==$classe) {
                            echo"<option value=\"$classe\" selected>$colore</option>";
                        }
                        else {
                            echo"<option value=\"$classe\">$colore</option>";
                        }
                    }
                ?>
                </select>
            </div>

            <div class="col-12 mt-3">
                    <button class="btn btn-primary float-right"><i class="fas fa-check"></i> Salva</button>
            </div><!--/usa questo markup se ti serve un salvataggio di una singola sezione-->
            
        </div>
    </form>
    